/*
 * Decompiled with CFR 0.152.
 */
package flash.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class BitOutput {
    private OutputStream myStream;
    private long buffer;
    private int bufferSize;
    private long bytesWritten;

    public BitOutput(OutputStream outputStream) {
        this.myStream = outputStream;
        this.buffer = 0L;
        this.bufferSize = 0;
        this.bytesWritten = 0L;
    }

    public void useCompression() throws IOException {
        this.myStream = new DeflaterOutputStream(this.myStream);
    }

    public void close() throws IOException {
        this.myStream.close();
    }

    public void flushStream() throws IOException {
        if (this.bufferSize > 0) {
            this.buffer <<= 8 - this.bufferSize;
            this.myStream.write((int)this.buffer);
            this.buffer = 0L;
            this.bufferSize = 0;
        }
    }

    public void writeBits(long l, int n) throws IOException {
        long l2 = 0L;
        while (n > 0) {
            if (n >= 8) {
                l2 = l;
                l2 >>= n - 8;
                n -= 8;
                this.buffer <<= 8;
                this.bufferSize += 8;
                this.buffer |= (l2 &= 0xFFL);
            } else {
                l2 = l;
                l2 >>= n - n;
                this.buffer <<= n;
                this.bufferSize += n;
                n = 0;
                this.buffer |= (l2 &= 0xFFL);
            }
            if (this.bufferSize < 8) continue;
            l2 = this.buffer;
            l2 = this.buffer >> this.bufferSize - 8 & 0xFFL;
            this.bufferSize -= 8;
            this.myStream.write((int)l2);
        }
    }

    public void writeByte(int n) throws IOException {
        this.flushStream();
        this.myStream.write(n);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.flushStream();
        for (int i = 0; i < byArray.length; ++i) {
            this.myStream.write(byArray[i]);
        }
    }

    public void ui8(int n) throws IOException {
        this.writeByte(n & 0xFF);
    }

    public void ui16(long l) throws IOException {
        this.ui8((int)l);
        this.ui8((int)(l >>= 8));
    }

    public void ui32(long l) throws IOException {
        this.ui16(l);
        this.ui16(l >>= 16);
    }

    public int determineMinimumBitCount(long l) {
        long l2 = -1L;
        long l3 = 0L;
        int n = 1;
        for (int i = 0; i < 32; ++i) {
            l3 = l & 1L;
            l >>= 1;
            if (l3 == l2) continue;
            n = i + 1;
            l2 = l3;
        }
        return n;
    }
}

